/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.analysis.dpManager;

import ibm.nways.analysis.dpCommon.DataPoint;
import ibm.nways.analysis.dpCommon.EventFilter;
import ibm.nways.analysis.dpCommon.GenericDataPoint;
import ibm.nways.analysis.dpCommon.MultipleNodePOAnalysis;
import ibm.nways.analysis.dpCommon.NotifyObject;
import ibm.nways.analysis.dpCommon.PerformanceEvent;
import ibm.nways.analysis.dpCommon.PollingObjectAnalysis;
import ibm.nways.analysis.dpCommon.PollingObjectDefinition;
import ibm.nways.analysis.dpCommon.PollingObjectInstance;
import ibm.nways.analysis.dpCommon.ResourceDefinition;
import ibm.nways.analysis.dpCommon.SingleNodeResourceAnalysis;
import ibm.nways.analysis.dpCommon.ThresholdAnalysis;
import ibm.nways.analysis.dpManager.EventRegistry;
import ibm.nways.analysis.dpManager.dpServerImpl;
import ibm.nways.nhm.eui.OptionsDialog;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.Vector;

public class StatisticalAnalyzer {
    public int startTime;
    public int endTime;
    public int startDay;
    public int endDay;
    private Calendar cal = new GregorianCalendar();
    private EventRegistry registry;
    private dpServerImpl refServer;

    public StatisticalAnalyzer(dpServerImpl dpServerImpl2, EventRegistry eventRegistry) {
        this.registry = eventRegistry;
        this.refServer = dpServerImpl2;
        this.cal.setTimeZone(TimeZone.getDefault());
        this.getOptions();
    }

    protected void getOptions() {
        DateFormat dateFormat = DateFormat.getTimeInstance(3);
        try {
            String string = this.refServer.getReportSetting(OptionsDialog.REPORT_OPTION_KEYWORDS[0]);
            try {
                this.startDay = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.startDay = 2;
            }
            string = this.refServer.getReportSetting(OptionsDialog.REPORT_OPTION_KEYWORDS[1]);
            try {
                this.endDay = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.endDay = 6;
            }
            string = this.refServer.getReportSetting(OptionsDialog.REPORT_OPTION_KEYWORDS[2]);
            try {
                this.cal.setTime(dateFormat.parse(string));
                this.startTime = this.cal.get(11) * 60 + this.cal.get(12);
            }
            catch (Exception exception) {
                this.startTime = 360;
            }
            string = this.refServer.getReportSetting(OptionsDialog.REPORT_OPTION_KEYWORDS[3]);
            try {
                this.cal.setTime(dateFormat.parse(string));
                this.endTime = this.cal.get(11) * 60 + this.cal.get(12);
                return;
            }
            catch (Exception exception) {
                this.endTime = 1080;
                return;
            }
        }
        catch (RemoteException remoteException) {
            this.startDay = 2;
            this.endDay = 6;
            this.startTime = 360;
            this.endTime = 1080;
            return;
        }
    }

    public SingleNodeResourceAnalysis performSingleNodeAnalysis(String string, String string2, Vector vector, long l, long l2) {
        SingleNodeResourceAnalysis singleNodeResourceAnalysis = new SingleNodeResourceAnalysis();
        try {
            int n;
            Serializable serializable;
            Object object;
            ResourceDefinition resourceDefinition = this.refServer.getResourceDefinition(string2);
            Vector vector2 = new Vector();
            Vector vector3 = null;
            dpServerImpl.DM("entering performSingleNodeAnalysis, resourceID = " + string2);
            Enumeration enumeration = resourceDefinition.getDefinitionVector().elements();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                vector3 = vector == null || vector.size() == 0 ? this.refServer.getPollingObjectIndices((String)object, string) : vector;
                serializable = this.refServer.getPollingObjectInstances((String)object, string, vector3, l, l2);
                n = 0;
                while (n < ((Vector)serializable).size()) {
                    vector2.addElement(((Vector)serializable).elementAt(n));
                    ++n;
                }
            }
            if (vector2 != null && vector2.size() != 0) {
                dpServerImpl.DM("retrieved " + vector2.size() + " polling instances");
                singleNodeResourceAnalysis.objects = new PollingObjectAnalysis[vector2.size()];
                n = 0;
                object = vector2.elements();
                while (object.hasMoreElements()) {
                    Serializable serializable2;
                    PollingObjectInstance pollingObjectInstance = (PollingObjectInstance)object.nextElement();
                    singleNodeResourceAnalysis.objects[n] = this.performAnalysis(pollingObjectInstance.getHistory());
                    singleNodeResourceAnalysis.objects[n].identifier = pollingObjectInstance.getIdentifier();
                    serializable = pollingObjectInstance.getNotifyObject();
                    if (serializable == null) {
                        serializable2 = this.refServer.getPollingDefinition(pollingObjectInstance.getIdentifier());
                        serializable = ((PollingObjectDefinition)serializable2).getNotifyObject();
                    }
                    if (serializable != null) {
                        singleNodeResourceAnalysis.objects[n].thresholdValue = ((NotifyObject)serializable).getArmValue();
                        singleNodeResourceAnalysis.objects[n].thresholdOperator = ((NotifyObject)serializable).getArmOp();
                    }
                    if (pollingObjectInstance.getValidNonZeroData()) {
                        serializable2 = (DataPoint)pollingObjectInstance.getHistory().elementAt(0);
                        singleNodeResourceAnalysis.objects[n].instanceId = ((GenericDataPoint)serializable2).getID();
                    }
                    ++n;
                }
            } else {
                dpServerImpl.DM("no polling instances retrieved by performSingleNodeAnalysis");
                singleNodeResourceAnalysis = null;
            }
        }
        catch (Exception exception) {
            dpServerImpl.DM("Exception caught in performSingleNodeAnalysis", exception);
        }
        return singleNodeResourceAnalysis;
    }

    public MultipleNodePOAnalysis performMultipleNodeAnalysis(String[] stringArray, String string, Vector[] vectorArray, long l, long l2) {
        MultipleNodePOAnalysis multipleNodePOAnalysis = new MultipleNodePOAnalysis();
        try {
            multipleNodePOAnalysis.nodeNames = stringArray;
            int n = stringArray.length;
            multipleNodePOAnalysis.objects = new PollingObjectAnalysis[n];
            int n2 = 0;
            while (n2 < n) {
                Vector vector = this.refServer.getPollingObjectInstances(string, stringArray[n2], vectorArray[n2], l, l2);
                if (vector != null && vector.size() > 0) {
                    PollingObjectInstance pollingObjectInstance = (PollingObjectInstance)vector.elementAt(0);
                    multipleNodePOAnalysis.objects[n2] = this.performAnalysis(pollingObjectInstance.getHistory());
                    multipleNodePOAnalysis.objects[n2].identifier = pollingObjectInstance.getIdentifier();
                    String string2 = vectorArray[n2] != null && vectorArray[n2].size() > 0 ? (String)vectorArray[n2].elementAt(0) : null;
                    multipleNodePOAnalysis.objects[n2].instanceId = string2;
                    NotifyObject notifyObject = pollingObjectInstance.getNotifyObject();
                    if (notifyObject == null) {
                        PollingObjectDefinition pollingObjectDefinition = this.refServer.getPollingDefinition(string);
                        notifyObject = pollingObjectDefinition.getNotifyObject();
                    }
                    if (notifyObject != null) {
                        multipleNodePOAnalysis.objects[n2].thresholdValue = notifyObject.getArmValue();
                        multipleNodePOAnalysis.objects[n2].thresholdOperator = notifyObject.getArmOp();
                    }
                } else {
                    dpServerImpl.DM("No polling object instances returned from server");
                }
                ++n2;
            }
        }
        catch (RemoteException remoteException) {
            System.out.println("Shouldn't get here");
        }
        catch (Exception exception) {
            dpServerImpl.DM("Exception caught in performMultipleNodeAnalysis", exception);
        }
        return multipleNodePOAnalysis;
    }

    protected PollingObjectAnalysis performAnalysis(Vector vector) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        PollingObjectAnalysis pollingObjectAnalysis = new PollingObjectAnalysis();
        if (vector.size() > 2) {
            DataPoint dataPoint = null;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                dataPoint = (DataPoint)enumeration.nextElement();
                if (dataPoint.getValue() == Float.NEGATIVE_INFINITY) continue;
                ++pollingObjectAnalysis.overallN;
                d += (double)dataPoint.getValue();
                d2 += (double)(dataPoint.getValue() * dataPoint.getValue());
                if (dataPoint.getValue() < pollingObjectAnalysis.overallLowWaterMark) {
                    pollingObjectAnalysis.overallLowWaterMark = dataPoint.getValue();
                    pollingObjectAnalysis.overallLowWaterTime = dataPoint.getDate();
                }
                if (dataPoint.getValue() > pollingObjectAnalysis.overallHighWaterMark) {
                    pollingObjectAnalysis.overallHighWaterMark = dataPoint.getValue();
                    pollingObjectAnalysis.overallHighWaterTime = dataPoint.getDate();
                }
                if (!this.isWeekday(dataPoint)) continue;
                ++pollingObjectAnalysis.weekdayN;
                d3 += (double)dataPoint.getValue();
                d4 += (double)(dataPoint.getValue() * dataPoint.getValue());
                if (dataPoint.getValue() < pollingObjectAnalysis.weekdayLowWaterMark) {
                    pollingObjectAnalysis.weekdayLowWaterMark = dataPoint.getValue();
                    pollingObjectAnalysis.weekdayLowWaterTime = dataPoint.getDate();
                }
                if (!(dataPoint.getValue() > pollingObjectAnalysis.weekdayHighWaterMark)) continue;
                pollingObjectAnalysis.weekdayHighWaterMark = dataPoint.getValue();
                pollingObjectAnalysis.weekdayHighWaterTime = dataPoint.getDate();
            }
            pollingObjectAnalysis.overallMean = (float)(d / (double)pollingObjectAnalysis.overallN);
            pollingObjectAnalysis.overallSd = (float)Math.sqrt((d2 - d * d / (double)pollingObjectAnalysis.overallN) / (double)(pollingObjectAnalysis.overallN - 1));
            if (pollingObjectAnalysis.weekdayN >= 2) {
                pollingObjectAnalysis.weekdayMean = (float)(d3 / (double)pollingObjectAnalysis.weekdayN);
                pollingObjectAnalysis.weekdaySd = (float)Math.sqrt((d4 - d3 * d3 / (double)pollingObjectAnalysis.weekdayN) / (double)(pollingObjectAnalysis.weekdayN - 1));
            }
        }
        return pollingObjectAnalysis;
    }

    public ThresholdAnalysis evaluateThresholds(String string, String string2, String string3, long l, long l2) {
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        long l3 = 0L;
        Integer n4 = new Integer(67);
        String string4 = null;
        try {
            string4 = InetAddress.getByName(string2).getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            string4 = string2;
        }
        EventFilter eventFilter = new EventFilter(n4, string, string4, l, l2);
        eventFilter.setIndexString(string3);
        Vector vector = this.registry.getEvents(eventFilter);
        String string5 = new String(string);
        if (string3 != null) {
            string5 = String.valueOf(string5) + "." + string3;
        }
        ThresholdAnalysis thresholdAnalysis = new ThresholdAnalysis(string5);
        PerformanceEvent performanceEvent = null;
        long l4 = 0L;
        long l5 = l;
        long l6 = 0L;
        n = this.convertToHistogramIndex(l5);
        if (vector != null) {
            int n5 = 0;
            while (n5 < vector.size()) {
                performanceEvent = (PerformanceEvent)vector.elementAt(n5);
                n3 = this.convertToHistogramIndex(performanceEvent.getEventTime());
                if (n2 != -1 && (n3 != n2 || performanceEvent.getEventTime() - l6 > 900000L)) {
                    thresholdAnalysis.updateHistogram(n, n2);
                    n = -1;
                    n2 = -1;
                }
                if (performanceEvent.getCause() == 1) {
                    l5 = performanceEvent.getEventTime();
                    n = this.convertToHistogramIndex(l5);
                    n2 = -1;
                } else if (performanceEvent.getCause() == 2) {
                    l4 += performanceEvent.getEventTime() - l5;
                    l6 = performanceEvent.getEventTime();
                    l5 = 0L;
                    n2 = this.convertToHistogramIndex(performanceEvent.getEventTime());
                }
                ++n5;
            }
            if (l5 != 0L) {
                l3 += l2 - l5;
                n2 = this.convertToHistogramIndex(l2);
                thresholdAnalysis.updateHistogram(n, n2);
            }
            if (l2 - l > 0L) {
                thresholdAnalysis.percentThresholdArmed = l3 / (l2 - l);
            }
        } else {
            dpServerImpl.DM("no events returned from server");
        }
        return thresholdAnalysis;
    }

    protected int convertToHistogramIndex(long l) {
        this.cal.setTime(new Date(l));
        int n = this.cal.get(11) * 60 + this.cal.get(12);
        return n / 15;
    }

    protected boolean isWeekday(DataPoint dataPoint) {
        boolean bl = false;
        this.cal.setTime(new Date(dataPoint.getDate()));
        int n = this.cal.get(7);
        int n2 = this.cal.get(11) * 60 + this.cal.get(12);
        if (n >= this.startDay && n <= this.endDay && n2 >= this.startTime && n2 <= this.endTime) {
            bl = true;
        }
        return bl;
    }
}

